<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserLink extends Model
{
    use HasFactory;
    
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'user_id',
        'title',
        'url',
        'category',
        'affiliate_url',
        'link_order',
    ];
    
    /**
     * Get the user that owns the link.
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }
    
    /**
     * Get the wishlist items for this link.
     */
    public function wishlistItems()
    {
        return $this->hasMany(WishlistItem::class);
    }
} 